﻿var elsFramework = new ELSFramework();
var fetchStringFromResource;

var TFSControls, TFSGrids, TFSMenus, TFSCommonControls;
var TFSCore;
var selectedNodeText;

var currentRowSelector = "#grid-host .grid-row-current";
var idColumnNumber = 0;
var stateColumnNumber = 1;
var runNameColumnNumber = 3;

var toolBarManualRefreshID = "toolBarManualRefresh";
var toolBarOpenID = "toolBarOpen";
var toolBarStopID = "toolBarStop";

var gridHostContainer = "#grid-host";
var GridContextMenuOpenOptionID = "GridContextMenuOpenOption";
var GridContextMenuStopOptionID = "GridContextMenuStopOption";
var gridObject;
var topMenuBar;
var filterHostContainer = "#test-run-filter";
var filterMenu;
var treeView;
var gridOptions;
var currentFilterRunById = "current_Filter_RunById";
var currentFilterDateId = "current_Filter_Date_Id";
var currentFilterStateId = "current_Filter_StateId";

var currentFilterRunByAllId = "current_Filter_RunBy_All_Id";
var currentFilterDateAnyId = "current_Filter_Date_Any_Id";
var currentFilterStateAllId = "current_Filter_State_All_Id";
var testRunFilter = new TestRunFilter();
var sortOrderColumn = 4;
var sortOrderOption = "desc";

var filterDateTodayId = "filterDateTodayID";
var filterRunByMeId = "@Me";
var requestedBy = {};
var statesObject = {};
var hideColumnsTillIndex = 1;
var maxLengthForStateColumn = 0;
var setIntervalId = null;
var splitter;
var tfsUrl;
var updatedTestRunData = [];
var gridColumnsNameMapping = {
    // All hidden column we are mapping in the start. And we should initialize the
    // hideColumnsTillIndex properly.
    Id: "Run GUID",
    State: "GridColumnState",
    RunNumber: "GridColumnId",
    Name: "GridColumnName",
    CreatedDate: "GridColumnCreated",
    FinishedDate: "GridColumnFinished",
    Duration: "GridColumnDuration",
    VirtualUserCount: "GridColumnVirtualUserCount",
    StartedBy: "GridColumnStartedBy",
    Location: "GridColumnLocation",
};

var stoppingTestRun = false;

window.onerror = function (msg, url, linenumber) {
    //Don't throw alert - we should land here as result of code flaw only, doesnot make sense to keep throwing popups on UI for such issues.
    elsFramework.LogError("ScriptedSandbox.exe, Msg: " + msg + " Url: " + url + " Line: " + linenumber);
    return true;
}

function getSortOrderOption() {
    return [
        {
            index: sortOrderColumn,
            order: sortOrderOption
        }
    ];
}
function testRunsObjectViewHelper(data) {
    if (data.length == 0) {
        hideOpenStopButtons();
    }
    var selectedIndex = gridObject.getSelectedRowIndex();
    if (data.length > 0 && selectedIndex === -1) {
        gridObject.setSelectedDataIndex(0);
        selectedIndex = gridObject.getSelectedRowIndex();
    }
    if (selectedIndex >= 0 && data.length > selectedIndex) {
        var testId = data[selectedIndex].Id;
    }
    gridObject.setDataSource(getSourceOptionsForTestRunsGrid(data), null, gridObject.getColumns(), gridObject.getSortOrder());
    // By default filter is not getting applied so firing the sortBy event on the grid.
    gridObject._sortBy(gridObject._columns[gridObject.getSortOrder().index], false);
    if (selectedIndex >= 0 && data.length > selectedIndex) {
        for (var i = 0, len = data.length; i < len; i++) {
            if (testId === data[i].Id) {
                gridObject.setSelectedDataIndex(i);
                break;
            }
        }
        updateMenuBar();
    }
}
// Received a JSON Object from the C# Layer, Constructs the grid options and then constructs the grid.
function testRunsObjectView(data) {
    testRunsObjectViewHelper(data);
    hideProgressBar();
    statesObject = {};
    updatedTestRunData = data;
    elsFramework.GetCodeMarkers().fire(elsFramework.GetCodeMarkers().CodeMarkerValues.PerfELS_OpeningLTMWindowWithRunsEnd);
    elsFramework.GetCodeMarkers().fire(elsFramework.GetCodeMarkers().CodeMarkerValues.PerfELS_LTMChangeFilterEnd);
    elsFramework.GetCodeMarkers().fire(elsFramework.GetCodeMarkers().CodeMarkerValues.PerfELS_LTMRefreshEnd);
    elsFramework.GetCodeMarkers().fire(elsFramework.GetCodeMarkers().CodeMarkerValues.PerfELS_LTMChangeTestNameEnd);
}

function InitiateLTMGetTestRun(initParam) {
    elsFramework.LogInfo("InitiateLTMGetTestRun: " + initParam.ConnectionStatus + " TfsUrl : " + initParam.TfsUrl);
    switch (initParam.ConnectionStatus) {
        case "Connecting":
            {
                var rightPane = $("#tfsconnection");
                rightPane.text(fetchStringFromResource("ElsConnectionInProgress", initParam.TfsUrl));
                rightPane.attr("Title", fetchStringFromResource("ElsConnectionInProgress", initParam.TfsUrl));
                break;
            }

        case "Connected":
            {
                tfsUrl = initParam.TfsUrl;
                var rightPane = $("#rightPaneText");
                rightPane.text(fetchStringFromResource("LtmTitleLabel"));
                rightPane.attr("Title", fetchStringFromResource("LtmTitleLabel"));
                var rightPane = $("#tfsconnection");
                rightPane.text(fetchStringFromResource("TfsConnectedInfo", tfsUrl));
                rightPane.attr("Title", fetchStringFromResource("TfsConnectedInfo", tfsUrl));
                showLoadingExperience();
                beginGetInitialData();
                break;
            }

        case "Failed":
            {
                var rightPane = $("#rightPaneText");
                rightPane.text(fetchStringFromResource("TfsConnectionFailedInfo", initParam.TfsUrl));
                rightPane.attr("Title", fetchStringFromResource("TfsConnectionFailedInfo", initParam.TfsUrl));
                hideProgressBar();
                disableMenuItemsOnFailedToConnect();
                break;
            }
    }
}

function disableMenuItemsOnFailedToConnect() {
    var commands = [];
    commands.push({ id: toolBarManualRefreshID, disabled: true }, { id: toolBarStopID, disabled: true }, { id: toolBarOpenID, disabled: true });
    topMenuBar.updateCommandStates(commands);
    var filterCommands = [];
    filterCommands.push({ id: currentFilterStateId, disabled: true }, { id: currentFilterDateId, disabled: true }, { id: currentFilterRunById, disabled: true });
    filterMenu.updateCommandStates(filterCommands);
}

function clearTopband() {
    $('#headerdiv').hide();
    $('#topbandtext').html("");
    $('#topbandlinks').html("");
}

function refresh() {
    clearTopband()
    if (setIntervalId) {
        clearInterval(setIntervalId);
        setIntervalId = null;
    }
    getTestRunNames();
}

function displayIntermittentError(error) {
    $('#topbandtext').html("&nbsp;" + error + "&nbsp;");
    $('#topbandlinks').html("<a id='viewdetails'>" +
        fetchStringFromResource("ViewDetailsLink") +
        "</a>&nbsp;|&nbsp;<a id='refresh'>" +
        fetchStringFromResource("RetryTag") +
        "</a>");

    $('#refresh').click(refresh);
    var newHtml = [];
    newHtml.push("<div unselectable=\"off\">" + error + "</div>");

    $('#viewdetails').click(function () {
        ShowBasicDialog($('#intermittenterrordetails'), fetchStringFromResource("ErrorDetailsTag"), newHtml);
    });
    $('#headerdiv').show();
}

function updateTestRunData(testRunData) {

    for (var i = 0, len = updatedTestRunData.length; i < len; i++) {
        if (updatedTestRunData[i].Id === testRunData.Id) {
            updatedTestRunData.splice(i, 1);
            updatedTestRunData.push(testRunData);
        }
    }
}

function myCopySelectedRow() {
    gridObject._beginCopySelection(null, null);
}

function getColumnOptionsForTestRunsGrid() {
    var columnOption = [];
    var columnWidth = 0;
    var columnIndex = 0;
    for (var property in gridColumnsNameMapping) {
        switch (gridColumnsNameMapping[property]) {

            case gridColumnsNameMapping.State:
            case gridColumnsNameMapping.RunNumber:
            case gridColumnsNameMapping.Duration:
                // For hidden column width will not matter.
            case gridColumnsNameMapping.Id:
            case gridColumnsNameMapping.VirtualUserCount:
                columnWidth = 75;
                break;
            case gridColumnsNameMapping.Name:
            case gridColumnsNameMapping.StartedBy:
                columnWidth = 150;
                break;
            case gridColumnsNameMapping.CreatedDate:
            case gridColumnsNameMapping.FinishedDate:
            case gridColumnsNameMapping.Location:
                columnWidth = 130;
                break;
        }
        if (columnIndex < hideColumnsTillIndex) {
            columnOption[columnIndex] = { text: gridColumnsNameMapping[property], index: (columnIndex), width: columnWidth, hidden: true };
        }
        else {
            columnOption[columnIndex] = { text: fetchStringFromResource(gridColumnsNameMapping[property]), index: (columnIndex), width: columnWidth };
        }

        // For State we want to show the column content with different colors according to the state vlaue.
        if (gridColumnsNameMapping[property] == gridColumnsNameMapping.State) {
            // State is being stored as internally as a class TestStatus, we need to specify a comparer for the same.
            columnOption[columnIndex].comparer = function (column, order, rowA, rowB) {
                var v1 = rowA[column.index];
                var v2 = rowB[column.index];

                return TFSCore.StringUtils.localeIgnoreCaseComparer(v1.ToUIString(), v2.ToUIString());
            };
            //To allow proper functioning of ctr+C
            columnOption[columnIndex].getColumnValue = function (dataIndex, columnIndex) {
                return this._dataSource[dataIndex][columnIndex].ToUIString();
            };
            // Set maxLength for the state as it is not string so grid apis will not calculate it.
            columnOption[columnIndex].maxLength = maxLengthForStateColumn;

            var testRunStatusColor = ['#808080', '#808080', '#6699CC', '#FF3333', '#669933', '#FF3333', '#FF3333'];
            columnOption[columnIndex].getCellContents = function (rowInfo, dataIndex, expandedState, level, column, indentIndex, columnOrder) {
                var testStatus = this.getColumnValue(dataIndex, column.index);
                return $("<div class='grid-cell'/>").width(column.width || maxLengthForStateColumn).html("<svg class='test-outcome'>" +
                    "<rect x='0' y='0' height='17' width='2' fill='" + testRunStatusColor[testStatus.State] + "'/></svg><span class='test-outcome-status-text'>" + testStatus.ToUIString() + "</span>");
            };
        }
        else if (gridColumnsNameMapping[property] == gridColumnsNameMapping.RunNumber
                 || gridColumnsNameMapping[property] == gridColumnsNameMapping.VirtualUserCount) {
            columnOption[columnIndex].comparer = function (column, order, rowA, rowB) {
                var a = parseInt(rowA[column.index]);
                var b = parseInt(rowB[column.index]);

                if (a == b) {
                    return 0;
                } else if (a > b) {
                    return 1;
                } else {
                    return -1;
                }
            }
        }
            // For dates, writing the data provider so that we can show the dates in right format.
        else if (property == "CreatedDate" || property == "FinishedDate") {
            // As this is date field so setting the max length according to the text we are going to set through getCellContents call.
            var date = new Date();
            columnOption[columnIndex].maxLength = date.toLocaleString().length;

            columnOption[columnIndex].getCellContents = function (rowInfo, dataIndex, expandedState, level, column, indentIndex, columnOrder) {
                if (typeof (this.getColumnValue(dataIndex, column.index)) === 'undefined') {
                    return $("<div class='grid-cell'/>").width(column.width || 150).text("");
                }
                else {
                    var date = new Date(this.getColumnValue(dataIndex, column.index));
                    return $("<div class='grid-cell'/>").width(column.width || 150).text(date.toLocaleString());
                }
            };
            columnOption[columnIndex].getColumnValue = function (dataIndex, columnIndex) {
                if (typeof this._dataSource[dataIndex][columnIndex] !== 'undefined')
                    return (new Date(this._dataSource[dataIndex][columnIndex])).toLocaleString();
                else
                    return this._dataSource[dataIndex][columnIndex];
            };
        }

        columnIndex++;
    }
    return columnOption;
}

function getSourceOptionsForTestRunsGrid(testRunsArray) {
    var testRunsArrayLength = testRunsArray.length;
    var sourceOption = [];
    if (testRunsArrayLength > 0) {

        var rowIndex = 0;
        $.each(testRunsArray, function () {

            var columnIndex = 0;
            var testRunValues = [];
            var ignoreRunSpecificDetails = this.RunSpecificDetails == null;
            var runSpecificDetailsObject
                    = (ignoreRunSpecificDetails == false ? this.RunSpecificDetails : null);
            for (var property in gridColumnsNameMapping) {
                switch (gridColumnsNameMapping[property]) {

                    case gridColumnsNameMapping.VirtualUserCount:
                        if (ignoreRunSpecificDetails == false) {
                            testRunValues[columnIndex] = runSpecificDetailsObject[property];
                        }
                        break;
                    case gridColumnsNameMapping.CreatedDate:
                        if (!elsFramework.IsNullOrUndefined(this[property])) {
                            var dateTime = new DateTime(this[property], "ISO");
                            testRunValues[columnIndex] = dateTime.GetJSDate().getTime();
                        }
                        break;
                    case gridColumnsNameMapping.FinishedDate:
                        // Storing the dates in milliseconds only, for show it will be
                        // converted to string by getCellContents override. For sorting
                        // default sort will work.
                        var currentTestRunState = new TestStatus(this.State, this.SubState, elsFramework.GetResource());
                        if (currentTestRunState.IsCompleted() || currentTestRunState.IsAborted()) {
                            if (!elsFramework.IsNullOrUndefined(this[property])) {
                                var dateTime = new DateTime(this[property], "ISO");
                                testRunValues[columnIndex] = dateTime.GetJSDate().getTime();
                            }
                        }
                        break;
                    case gridColumnsNameMapping.StartedBy:
                        if (this.StartedBy.displayName.trim()) {
                            testRunValues[columnIndex] = this.StartedBy.displayName;
                            requestedBy[testRunValues[columnIndex]] = this.StartedBy.id;
                        }
                        else {
                            testRunValues[columnIndex] = this.CreatedBy.displayName;
                            requestedBy[testRunValues[columnIndex]] = this.CreatedBy.id;
                        }
                        break;
                    case gridColumnsNameMapping.State:
                        var currentTestRunState = new TestStatus(this.State, this.SubState, elsFramework.GetResource());
                        testRunValues[columnIndex] = currentTestRunState;
                        break;
                    case gridColumnsNameMapping.Duration:
                        if (ignoreRunSpecificDetails == false) {
                            if(!elsFramework.IsNullOrUndefined(runSpecificDetailsObject[property]))
                                testRunValues[columnIndex] = new TimeSpan(runSpecificDetailsObject[property]).ToString();
                        }
                        break;
                    case gridColumnsNameMapping.Location:
                        if (this.LoadGenerationGeoLocations != null) {
                            // get the Locations (first column) and join them with ',' separator.
                            var locations = this.LoadGenerationGeoLocations.map(function (value, index) { return value["Location"]; }).join(",");
                            testRunValues[columnIndex] = locations;
                        }
                        break;
                    default:
                        testRunValues[columnIndex] = this[property];
                        break;
                }
                columnIndex++;
            }
            sourceOption[rowIndex] = testRunValues;
            rowIndex++;
        });
    }
    return sourceOption;
}


function constructGridOptionsFromTestRunResults() {

    var gridOptions = {
        columns: getColumnOptionsForTestRunsGrid(),
        allowMultiSelect: false,
        gutter: {
            contextMenu: true
        },
        contextMenu: {
            items: getContextMenuForGrid(),
            executeAction: function (e, args) {
                handleContextMenuClick(e, args);
            },
            getCommandState: function (commandId, context) {
                if (commandId == GridContextMenuStopOptionID) {
                    var currentSelectedRow = $(currentRowSelector);
                    if (currentSelectedRow) {
                        if (gridObject.getRowData(gridObject.getSelectedRowIndex())[stateColumnNumber].IsFinished()
                                || gridObject.getRowData(gridObject.getSelectedRowIndex())[stateColumnNumber].IsStopping()
                                || stoppingTestRun) {
                            return TFSMenus.MenuItemState.Disabled;
                        }
                    }
                }

                return TFSMenus.MenuItemState.None;
            }
        },
        // Setting sort order, but this is currently not being hounored properly,
        // by web access layer, need to find a workaround for the same.
        sortOrder: getSortOrderOption(),
        openRowDetail: function (e, args) {
            openCurrentSelectedTestRun();
        }
    };

    return gridOptions;
}

function createMenubarItems() {
    var items = [];

    items.push({ id: toolBarManualRefreshID, icon: "icon-refresh", title: fetchStringFromResource("ToolBarRefresh") });

    items.push({ separator: true });

    items.push({ id: toolBarOpenID, icon: "icon-open-2", title: fetchStringFromResource("ToolBarOpen") });
    items.push({ id: toolBarStopID, icon: "icon-test-aborted", title: fetchStringFromResource("ToolBarStop") });
    return items;
}

function createMenubar($container, menuBarItems, clickCallBack, showIcon) {
    var menu = TFSControls.BaseControl.createIn(TFSMenus.MenuBar, $container, {
        items: menuBarItems,
        executeAction: function (e, args) {
            clickCallBack(e, args);
        },
        showIcon: showIcon
    });
    return menu;
}

function createTestRunFilters() {
    var filters = [];

    filters.push({
        id: currentFilterStateId, hideDrop: true, text: fetchStringFromResource("FilterStateDefault"),
        childItems: getAllTestStatesForFilters(),
    });

    filters.push({
        id: currentFilterDateId, hideDrop: true, text: fetchStringFromResource("FilterDateLast7Days"),
        childItems: getAllDatesForFilters(),
    });

    //testRunFilter.Modified = getCurrentTimeSpan().ToString();
    // T-7 is by default
    testRunFilter.Modified = 7;

    filters.push({
        id: currentFilterRunById, hideDrop: true, text: fetchStringFromResource("FilterRunByDefault"),
        childItems: getAllNamesForFilters()
    });

    var $filterContainer = $(filterHostContainer);
    var showIcon = false;

    filterMenu = createMenubar($filterContainer, filters, handleFilterClick, showIcon);

}

function updateFilterTexts() {
    var runByFilter = $("li[command='" + currentFilterRunById + "']");
    runByFilter.prepend("<span class='filterLabel'>" + fetchStringFromResource("FilterRunByLabel") + " </span>");

    var stateFilter = $("li[command='" + currentFilterStateId + "']");
    stateFilter.prepend("<span class='filterLabel'>" + fetchStringFromResource("FilterStateLabel") + " </span>");

    var dateFilter = $("li[command='" + currentFilterDateId + "']");
    dateFilter.prepend("<span class='filterLabel'>" + fetchStringFromResource("FilterDateLabel") + " </span>");
}


function treeViewCreator(testRunNamesArray, fetchTestRuns) {
    testRunNamesArray.sort();
    var treeData = [];
    treeData.push({ name: fetchStringFromResource("TreeViewAllLoadTest") });
    $.each(testRunNamesArray, function () {
        treeData.push({ name: this.toString() });
    });
    var source = [
        {
            name: fetchStringFromResource("TreeViewLoadTest"),
            children: treeData
        }
    ];
    createTreeView($("#LoadTestsTreeView"), source, fetchTestRuns);
}

// Converts the source to TreeNodes
function convertToTreeNodes(items) {
    return $.map(items, function (item) {
        var node = new TFSControls.TreeNode(item.name);
        node.icon = item.icon;
        if (item.children && item.children.length > 0) {
            node.addRange(convertToTreeNodes(item.children));
        }
        return node;
    });
}

function getContextMenuForGrid() {
    return [
        { id: GridContextMenuOpenOptionID, text: fetchStringFromResource("RightClickOpen"), icon: "icon-open-2" },
        { id: GridContextMenuStopOptionID, text: fetchStringFromResource("RightClickStop"), icon: "icon-test-aborted" },
    ];
}

function createTreeView($container, rawTreeData, fetchTestRuns) {
    // Generate TreeView options
    var treeviewOptions = {
        width: "100%",
        height: "100%",
        nodes: convertToTreeNodes(rawTreeData),
    };
    $container.html('');
    treeView = TFSControls.BaseControl.createIn(TFSCommonControls.TreeView, $container, treeviewOptions);
    treeView.onItemClick = function (selectedTreeItem) {
        handleTreeMenuClick(treeView, selectedTreeItem);
        selectedNodeText = selectedTreeItem.text;
    };
    if (typeof selectedNodeText === 'undefined') {
        treeView.setSelectedNode(treeviewOptions.nodes[0].children[0]);
        selectedNodeText = treeView.getSelectedNode().text;
    }
    else {
        for (var i = 0, len = treeviewOptions.nodes[0].children.length; i < len; i++) {
            if (selectedNodeText == treeviewOptions.nodes[0].children[i].text) {
                treeView.setSelectedNode(treeviewOptions.nodes[0].children[i]);
                break;
            }
        }
    }

    //$(gridHostContainer).html("");
    if (typeof gridOptions == 'undefined') {
        gridOptions = constructGridOptionsFromTestRunResults();
        // Storing gridObject to get the hidden column's data as well.
        gridObject = TFSControls.BaseControl.createIn(TFSGrids.Grid, $(gridHostContainer), gridOptions);
        // Copy funtionality from webAccess layer leads to crash as it looks for the TFSContext for
        // resource files. Hence overriding the _copySelectedItems for me.
        gridObject._copySelectedItems = myCopySelectedRow;
        gridObject.onRowClick = updateMenuBar;
        gridObject.selectedIndexChanged = updateMenuBar;
    }
    if (fetchTestRuns) {
        getTestRuns();
    }
}

function handleContextMenuClick(sender, args) {
    switch (sender.get_commandName()) {
        case GridContextMenuStopOptionID:
            stopCurrentSelectedTestRun();
            break;
        case GridContextMenuOpenOptionID:
            openCurrentSelectedTestRun();
            break;
    }
}

function handleToolBarClick(sender, args) {
    switch (sender.get_commandName()) {
        case toolBarStopID:
            stopCurrentSelectedTestRun();
            break;
        case toolBarOpenID:
            openCurrentSelectedTestRun();
            break;
        case toolBarManualRefreshID:
            elsFramework.GetCodeMarkers().fire(elsFramework.GetCodeMarkers().CodeMarkerValues.PerfELS_LTMRefreshStart);
            // On clicking manual refresh clearing the setIntervalId so as to maintain synchronization of autorefresh i.e. single instance of setInterval getting callled every 30 seconds  
            showLoadingExperience();
            if (setIntervalId) {
                clearInterval(setIntervalId);
                setIntervalId = null;
            }
            getTestRunNames();
            break;
    }
}

function handleFilterClick(sender, args) {
    elsFramework.GetCodeMarkers().fire(elsFramework.GetCodeMarkers().CodeMarkerValues.PerfELS_LTMChangeFilterStart);
    var command = sender.get_commandName();
    var parentMenu, parentMenuId;

    try {
        parentMenu = sender.get_commandSource()._parent._parent;
        parentMenuId = parentMenu.getCommandId();
        var menuText = sender.get_commandSource().getElement().text();
        parentMenu.updateTitle(menuText);
        parentMenu.updateText(menuText);
        switch (parentMenuId) {
            case currentFilterRunById:
                if (command == currentFilterRunByAllId) {
                    testRunFilter.Runby = undefined;
                }
                else if (command == filterRunByMeId) {
                    testRunFilter.Runby = command;
                }
                break;
            case currentFilterStateId:
                if (command == currentFilterStateAllId) {
                    testRunFilter.State = undefined;
                }
                else {
                    testRunFilter.State = command;
                }
                break;
            case currentFilterDateId:
                if (command == currentFilterDateAnyId) {
                    testRunFilter.Modified = undefined;
                }
                else {
                    if (command == filterDateTodayId) {
                        testRunFilter.Modified = getCurrentTimeSpan().ToString();
                    }
                    else {
                        testRunFilter.Modified = command;
                    }
                }
                break;
        }
    } catch (e) {

    }
    getTestRuns();
}

function handleTreeMenuClick(treeView, selectedTreeItem) {
    if (selectedTreeItem.id > 0) {
        elsFramework.GetCodeMarkers().fire(elsFramework.GetCodeMarkers().CodeMarkerValues.PerfELS_LTMChangeTestNameStart);
        var testName;
        treeView.setSelectedNode(selectedTreeItem);
        if (selectedTreeItem.text !== treeView._options.nodes[0].children[0].text) {
            testRunFilter.TestName = selectedTreeItem.text;
            testName = selectedTreeItem.text;
        }
        else {
            testRunFilter.TestName = "";
            testName = fetchStringFromResource("TreeViewAllLoadTest");
        }
        var rightPane = $("#rightPaneText");
        rightPane.text(testName);
        rightPane.attr("Title", testName);
        getTestRuns();
    }
}

function getCurrentTimeSpan() {
    var currentDateTime = new Date();
    var currentDateOnly = new Date(currentDateTime.toDateString());
    var seconds = (currentDateTime - currentDateOnly) / 1000;
    var timeSpan = new TimeSpan(seconds);
    return timeSpan;
}

function getCurrentSelectedTestRun() {
    var currentSelectedRow = $(currentRowSelector);
    if (currentSelectedRow.length != 0) {
        var selectedTestRun = {};
        selectedTestRun.TestRunName = gridObject.getRowData(gridObject.getSelectedRowIndex())[runNameColumnNumber];
        selectedTestRun.TestRunId = gridObject.getRowData(gridObject.getSelectedRowIndex())[idColumnNumber];
        return selectedTestRun;
    } else {
        return null;
    }
}

function showLoadingExperience() {
    clearTopband();
    $(".pageProgressIndicator").show();
    $(".query-title .status-indicator").show();
}

function hideProgressBar() {
    $(".pageProgressIndicator").hide();
    $(".query-title .status-indicator").hide();
}

function onFrameworkReady() {

}

function InitializeLTMWindow(initparam) {
    fetchStringFromResource = elsFramework.GetResource().GetString;
    buildHTML(initparam.TfsUrl);
    tfsUrl = initparam.TfsUrl;
    createTestRunFilters();
    updateFilterTexts();
    topMenuBar = createMenubar($("#LoadTestToolBar"), createMenubarItems(), handleToolBarClick, true);
    hideOpenStopButtons();
    treeViewCreator([], false);
    showLoadingExperience();
    if (initparam.IsConnected)
        beginGetInitialData();
}

function beginGetInitialData() {
    elsFramework.GetTestServiceClient().GetTestRuns(testRunFilter.TestName, testRunFilter.Runby, testRunFilter.State, testRunFilter.Modified, initialTestDataCallback, errorCallback);
}

function initialTestDataCallback(data) {
    treeViewCreator(getUniqueTestNames(data), false);
    testRunsObjectView(data);
    showLoadingExperience();
    getTestRunNamesNoAllTestFetch();
}

function getUniqueTestNames(testRunsArray) {
    var testNamesSet = {},
        testNames = [],
        testName = null,
        index = 0,
        totalTestRuns = testRunsArray.length;

    for (index = 0; index < totalTestRuns; index++) {
        testNamesSet[testRunsArray[index].Name] = true;
    }

    for (testName in testNamesSet) {
        testNames.push(testName);
    }

    return testNames;
}


function buildHTML(TfsUrl) {
    splitter = TFSControls.BaseControl.createIn(TFSCommonControls.Splitter, $(".hub-content"),
               { enableToggleButton: true, vertical: false, fixedSide: "left", cssClass: "splitter", collapsedLabel: fetchStringFromResource("TreeViewLoadTest") });
    var $leftPaneHtml = $("<div>").addClass("left-hub-content").append($("<div>").attr("id", "LoadTestsTreeView"));
    splitter.leftPane.append($leftPaneHtml);
    var rightPanelHtml = "<div id='headerdiv'><label id='topbandtext' unselectable=\"off\"></label><label id='topbandlinks'></label></div><div>\
                           <div class='hub-title'><div class='query-result-grid-info'>\
                           <table><tr><td class='query-title'><div class='status-indicator inline' style='display: none;'>\
                           <div class='status status-inline'></div><span class='status-progress'></span></div>\
                           <span id='rightPaneText' title='All load tests'>" + fetchStringFromResource("TfsConnectionInProgress") + "</span></td>\
                           <td class='query-status hub-title-right'>\
                           </td></tr></table></div></div>\
                            <div class-'hub-righttitle'><table align=\"right\"><tr><td align=\"right\"> <span id='tfsconnection' title='tests'></span></td></tr></table></div>\
                           <div class='hub-progress pageProgressIndicator' style='display: none;'></div>\
                           <div class='right-hub-content'><div class='hub-pivot'><div class='cutomFilters'>\
                           <div id='test-run-filter'></div>\
                           </div></div><div class='hub-pivot-content'>\
                           <div class='toolbar query-result-grid-toolbar' id='LoadTestToolBar'></div>\
                           <div id='grid-host'></div></div></div></div><div id='intermittenterrordetails'></div>";
    splitter.rightPane.html(rightPanelHtml);
    splitter._element.addClass("hub-splitter divided-section toggle-button-enabled toggle-button-hotkey-enabled");
    splitter.resize("250px", true);
}

function getTestRuns() {
    showLoadingExperience();
    elsFramework.GetTestServiceClient().GetTestRuns(testRunFilter.TestName, testRunFilter.Runby, testRunFilter.State, testRunFilter.Modified, testRunsObjectView, errorCallback);
}

function getTestRunNames() {
    elsFramework.GetTestServiceClient().GetTestRunsNames(null, null, null, null, treeViewCreatorCallback, errorCallback);
}

function getTestRunNamesNoAllTestFetch() {
    elsFramework.GetTestServiceClient().GetTestRunsNames(testRunFilter.TestName, testRunFilter.Runby, testRunFilter.State, testRunFilter.Modified, treeViewCreatorCallbackWithoutTestFetch, errorCallback);
}

function treeViewCreatorCallbackWithoutTestFetch(testRunNamesArray) {
    treeViewCreator(testRunNamesArray, false);
    hideProgressBar();
}

function treeViewCreatorCallback(testRunNamesArray) {
    treeViewCreator(testRunNamesArray, true);
}

function errorCallback(error) {
    if (elsFramework.GetTestServiceClient().IsIntermittentError(error)) {
        displayIntermittentError(error.message);
    }
    elsFramework.LogError("Get test runs/names error: " + error.message);
    alert(error.message);
    hideOpenStopButtons();
}

function hideOpenStopButtons() {
    hideProgressBar();
    var commands = [];
    commands.push({ id: toolBarStopID, disabled: true }, { id: toolBarOpenID, disabled: true });
    topMenuBar.updateCommandStates(commands);
}

function enableStopButton(enable) {
    var commands = [];
    commands.push({ id: toolBarStopID, disabled: !enable });
    topMenuBar.updateCommandStates(commands);
}

$(document).ready(function () {

    require(["Presentation/Scripts/TFS/TFS.UI.Controls", "Presentation/Scripts/TFS/TFS.UI.Controls.Common", "Presentation/Scripts/TFS/TFS.UI.Controls.Grids", "Presentation/Scripts/TFS/TFS.UI.Controls.Menus", "Presentation/Scripts/TFS/TFS.Core"], function (Controls, CommonControls, Grids, Menus, Core) {
        TFSControls = Controls;
        TFSGrids = Grids;
        TFSMenus = Menus;
        TFSCommonControls = CommonControls;
        TFSCore = Core;
        elsFramework.Init({ OnFrameworkReady: onFrameworkReady, TestRunsObjectView: testRunsObjectView });
    });

});

$(document).keydown(function (e) {
    var f1KeyCode = 112;

    if (e.keyCode === f1KeyCode) {
        // Returning false will prevent propagation of the keydown event when F1 is pressed.
        return false;
    }
});

function getAllTestStatesForFilters() {
    var testStatus = new TestStatus(0, 0, elsFramework.GetResource());
    var testStatusNames = testStatus.getAllStatusString();
    statesFilter = [];
    statesFilter.push({ id: currentFilterStateAllId, text: fetchStringFromResource("FilterStateDefault") });
    maxLengthForStateColumn = 0;

    for (var i = 0; i < testStatusNames.length; i++) {
        testStatus = new TestStatus(i, 0, elsFramework.GetResource());
        textForUI = testStatus.ToUIString();
        maxLengthForStateColumn = Math.max(maxLengthForStateColumn, textForUI.length);
        statesFilter.push({ id: testStatusNames[i], text: textForUI });
    }

    return statesFilter;
}

function getAllDatesForFilters() {
    var dateFilters = [];

    dateFilters.push({ id: filterDateTodayId, text: fetchStringFromResource("FilterDateToday") });
    dateFilters.push({ id: currentFilterDateAnyId, text: fetchStringFromResource("FilterDateDefault") });
    dateFilters.push({ id: 1, text: fetchStringFromResource("FilterDateLast24Hours") });
    dateFilters.push({ id: 7, text: fetchStringFromResource("FilterDateLast7Days") });
    dateFilters.push({ id: 14, text: fetchStringFromResource("FilterDateLast14Days") });
    dateFilters.push({ id: 28, text: fetchStringFromResource("FilterDateLast28Days") });

    return dateFilters;
}

function getAllNamesForFilters() {
    var testRunNamesFilterOptions = [];
    testRunNamesFilterOptions.push({ id: currentFilterRunByAllId, text: fetchStringFromResource("FilterRunByDefault") });
    testRunNamesFilterOptions.push({ id: filterRunByMeId, text: fetchStringFromResource("FilterRunByMe") });
    return testRunNamesFilterOptions;
};

function openCurrentSelectedTestRun() {
    elsFramework.GetCodeMarkers().fire(elsFramework.GetCodeMarkers().CodeMarkerValues.PerfELS_OpenTabStart);
    elsFramework.GetCodeMarkers().fire(elsFramework.GetCodeMarkers().CodeMarkerValues.PerfELS_OpeningLTRWindowWithRunStateStart);
    elsFramework.GetCodeMarkers().fire(elsFramework.GetCodeMarkers().CodeMarkerValues.PerfELS_OpeningLTRWindowWithAllDataStart);
    var currentSelectedTestRun = getCurrentSelectedTestRun();
    if (currentSelectedTestRun) {
        elsFramework.OpenTestRun(currentSelectedTestRun);
        elsFramework.GetCodeMarkers().fire(elsFramework.GetCodeMarkers().CodeMarkerValues.PerfELS_OpeningLTRWindowWithRunStateEnd);
        elsFramework.GetCodeMarkers().fire(elsFramework.GetCodeMarkers().CodeMarkerValues.PerfELS_OpeningLTRWindowWithAllDataEnd);
    }
}

function stopCurrentSelectedTestRun() {
    var currentSelectedTestRun = getCurrentSelectedTestRun();

    if (currentSelectedTestRun) {
        enableStopButton(false);
        showLoadingExperience();
        stoppingTestRun = true;
        elsFramework.GetTestServiceClient().StopTestRunById(currentSelectedTestRun.TestRunId, function (testRun) {
            updateTestRunData(testRun);
            testRunsObjectViewHelper(updatedTestRunData);
            hideProgressBar();
            stoppingTestRun = false;
            updateMenuBar();
        });
    }
}

function updateMenuBar() {
    var currentSelectedRow = $(currentRowSelector);
    if (currentSelectedRow && currentSelectedRow.length > 0) {
        var commands = [{ id: toolBarOpenID, state: 0 }];

        if (gridObject.getRowData(gridObject.getSelectedRowIndex())[stateColumnNumber].IsFinished()
                || gridObject.getRowData(gridObject.getSelectedRowIndex())[stateColumnNumber].IsStopping()
                || stoppingTestRun) {
            commands.push({ id: toolBarStopID, disabled: true });
            topMenuBar.updateCommandStates(commands);
        } else {
            commands.push({ id: toolBarStopID, state: 0 });
            topMenuBar.updateCommandStates(commands);
        }
    }
}

// SIG // Begin signature block
// SIG // MIIaswYJKoZIhvcNAQcCoIIapDCCGqACAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFG4dPpvXlT+5
// SIG // Jsq1t6SuS8qlx4kNoIIVgjCCBMMwggOroAMCAQICEzMA
// SIG // AABvZS1YbQcRRigAAAAAAG8wDQYJKoZIhvcNAQEFBQAw
// SIG // dzELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjEhMB8GA1UEAxMYTWlj
// SIG // cm9zb2Z0IFRpbWUtU3RhbXAgUENBMB4XDTE1MDMyMDE3
// SIG // MzIwMloXDTE2MDYyMDE3MzIwMlowgbMxCzAJBgNVBAYT
// SIG // AlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQH
// SIG // EwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29y
// SIG // cG9yYXRpb24xDTALBgNVBAsTBE1PUFIxJzAlBgNVBAsT
// SIG // Hm5DaXBoZXIgRFNFIEVTTjpDMEY0LTMwODYtREVGODEl
// SIG // MCMGA1UEAxMcTWljcm9zb2Z0IFRpbWUtU3RhbXAgU2Vy
// SIG // dmljZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
// SIG // ggEBAM/mbc3BKs2uqF7YlU8tA0NHczu4QtLQV5rd9lM2
// SIG // d9WIRSRqyKvQZumLxaoPnvKDRrYqydg2xvSg/xFvZvBe
// SIG // FBmysWf48V6UhqqOJa/4NRP9gi/HOF5TwHYcxdN5O7Bj
// SIG // 60+TmgXwohdx3MYMltMABS5MbVizf7QsJHB7lmksbIp4
// SIG // CW1JmY46PmaVj09/eBtge1fJUfRLbVHDNLf4OgrWEd/D
// SIG // OqUeoDjc662q+EPEg5qNlzQDNAQa761UNqTUGiz9w27w
// SIG // eOcp8blEwHG0L8QQiwz3NmJ5/QdXfeoFfEyfTjA/J1A4
// SIG // Zga7Xag+xZDb3zx2Vq2VIDRTcu1pWW7wVB9A1TkCAwEA
// SIG // AaOCAQkwggEFMB0GA1UdDgQWBBTypkkpeHxXcFJiz+2s
// SIG // t3sgNEfc/TAfBgNVHSMEGDAWgBQjNPjZUkZwCu1A+3b7
// SIG // syuwwzWzDzBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8v
// SIG // Y3JsLm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0
// SIG // cy9NaWNyb3NvZnRUaW1lU3RhbXBQQ0EuY3JsMFgGCCsG
// SIG // AQUFBwEBBEwwSjBIBggrBgEFBQcwAoY8aHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNyb3Nv
// SIG // ZnRUaW1lU3RhbXBQQ0EuY3J0MBMGA1UdJQQMMAoGCCsG
// SIG // AQUFBwMIMA0GCSqGSIb3DQEBBQUAA4IBAQCNs0y22OwN
// SIG // h4YZXuQA55e41c9MCjy991XT9PCgr1VynCOXuYIqxxYK
// SIG // xScTWdDaMCuIQrpSA+ZeySVoJyeNZKdt+beaaqs+rELQ
// SIG // HiQmzFSv9pCBax6tQ58bexBXajI2MaJEaAGYWisStIkx
// SIG // 9kwMrhU8tyQkXbv/fFNMhMQNzUZ3finKn7JGYoK0NMf1
// SIG // EmlcrXnNMe7pR474/FPz5AKQUWvO+p3jhb9ZgFkQ1Wej
// SIG // TKby5KC02ME6oWpIpojOcPapnN7zU5M9cHEA/77rfPz/
// SIG // CGMPS1FZqxUZkHQe/7u9qjWbPZ7zEBTVevYf1uJ185J0
// SIG // Da0W2RLPoZut0hLqADsjFQzPMIIE7DCCA9SgAwIBAgIT
// SIG // MwAAAQosea7XeXumrAABAAABCjANBgkqhkiG9w0BAQUF
// SIG // ADB5MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGlu
// SIG // Z3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMV
// SIG // TWljcm9zb2Z0IENvcnBvcmF0aW9uMSMwIQYDVQQDExpN
// SIG // aWNyb3NvZnQgQ29kZSBTaWduaW5nIFBDQTAeFw0xNTA2
// SIG // MDQxNzQyNDVaFw0xNjA5MDQxNzQyNDVaMIGDMQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMQ0wCwYDVQQLEwRNT1BSMR4wHAYD
// SIG // VQQDExVNaWNyb3NvZnQgQ29ycG9yYXRpb24wggEiMA0G
// SIG // CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCS/G82u+ED
// SIG // uSjWRtGiYbqlRvtjFj4u+UfSx+ztx5mxJlF1vdrMDwYU
// SIG // EaRsGZ7AX01UieRNUNiNzaFhpXcTmhyn7Q1096dWeego
// SIG // 91PSsXpj4PWUl7fs2Uf4bD3zJYizvArFBKeOfIVIdhxh
// SIG // RqoZxHpii8HCNar7WG/FYwuTSTCBG3vff3xPtEdtX3gc
// SIG // r7b3lhNS77nRTTnlc95ITjwUqpcNOcyLUeFc0Tvwjmfq
// SIG // MGCpTVqdQ73bI7rAD9dLEJ2cTfBRooSq5JynPdaj7woY
// SIG // SKj6sU6lmA5Lv/AU8wDIsEjWW/4414kRLQW6QwJPIgCW
// SIG // Ja19NW6EaKsgGDgo/hyiELGlAgMBAAGjggFgMIIBXDAT
// SIG // BgNVHSUEDDAKBggrBgEFBQcDAzAdBgNVHQ4EFgQUif4K
// SIG // MeomzeZtx5GRuZSMohhhNzQwUQYDVR0RBEowSKRGMEQx
// SIG // DTALBgNVBAsTBE1PUFIxMzAxBgNVBAUTKjMxNTk1KzA0
// SIG // MDc5MzUwLTE2ZmEtNGM2MC1iNmJmLTlkMmIxY2QwNTk4
// SIG // NDAfBgNVHSMEGDAWgBTLEejK0rQWWAHJNy4zFha5TJoK
// SIG // HzBWBgNVHR8ETzBNMEugSaBHhkVodHRwOi8vY3JsLm1p
// SIG // Y3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9NaWND
// SIG // b2RTaWdQQ0FfMDgtMzEtMjAxMC5jcmwwWgYIKwYBBQUH
// SIG // AQEETjBMMEoGCCsGAQUFBzAChj5odHRwOi8vd3d3Lm1p
// SIG // Y3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY0NvZFNpZ1BD
// SIG // QV8wOC0zMS0yMDEwLmNydDANBgkqhkiG9w0BAQUFAAOC
// SIG // AQEApqhTkd87Af5hXQZa62bwDNj32YTTAFEOENGk0Rco
// SIG // 54wzOCvYQ8YDi3XrM5L0qeJn/QLbpR1OQ0VdG0nj4E8W
// SIG // 8H6P8IgRyoKtpPumqV/1l2DIe8S/fJtp7R+CwfHNjnhL
// SIG // YvXXDRzXUxLWllLvNb0ZjqBAk6EKpS0WnMJGdAjr2/TY
// SIG // pUk2VBIRVQOzexb7R/77aPzARVziPxJ5M6LvgsXeQBkH
// SIG // 7hXFCptZBUGp0JeegZ4DW/xK4xouBaxQRy+M+nnYHiD4
// SIG // BfspaxgU+nIEtwunmmTsEV1PRUmNKRot+9C2CVNfNJTg
// SIG // FsS56nM16Ffv4esWwxjHBrM7z2GE4rZEiZSjhjCCBbww
// SIG // ggOkoAMCAQICCmEzJhoAAAAAADEwDQYJKoZIhvcNAQEF
// SIG // BQAwXzETMBEGCgmSJomT8ixkARkWA2NvbTEZMBcGCgmS
// SIG // JomT8ixkARkWCW1pY3Jvc29mdDEtMCsGA1UEAxMkTWlj
// SIG // cm9zb2Z0IFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5
// SIG // MB4XDTEwMDgzMTIyMTkzMloXDTIwMDgzMTIyMjkzMlow
// SIG // eTELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjEjMCEGA1UEAxMaTWlj
// SIG // cm9zb2Z0IENvZGUgU2lnbmluZyBQQ0EwggEiMA0GCSqG
// SIG // SIb3DQEBAQUAA4IBDwAwggEKAoIBAQCycllcGTBkvx2a
// SIG // YCAgQpl2U2w+G9ZvzMvx6mv+lxYQ4N86dIMaty+gMuz/
// SIG // 3sJCTiPVcgDbNVcKicquIEn08GisTUuNpb15S3GbRwfa
// SIG // /SXfnXWIz6pzRH/XgdvzvfI2pMlcRdyvrT3gKGiXGqel
// SIG // cnNW8ReU5P01lHKg1nZfHndFg4U4FtBzWwW6Z1KNpbJp
// SIG // L9oZC/6SdCnidi9U3RQwWfjSjWL9y8lfRjFQuScT5EAw
// SIG // z3IpECgixzdOPaAyPZDNoTgGhVxOVoIoKgUyt0vXT2Pn
// SIG // 0i1i8UU956wIAPZGoZ7RW4wmU+h6qkryRs83PDietHdc
// SIG // pReejcsRj1Y8wawJXwPTAgMBAAGjggFeMIIBWjAPBgNV
// SIG // HRMBAf8EBTADAQH/MB0GA1UdDgQWBBTLEejK0rQWWAHJ
// SIG // Ny4zFha5TJoKHzALBgNVHQ8EBAMCAYYwEgYJKwYBBAGC
// SIG // NxUBBAUCAwEAATAjBgkrBgEEAYI3FQIEFgQU/dExTtMm
// SIG // ipXhmGA7qDFvpjy82C0wGQYJKwYBBAGCNxQCBAweCgBT
// SIG // AHUAYgBDAEEwHwYDVR0jBBgwFoAUDqyCYEBWJ5flJRP8
// SIG // KuEKU5VZ5KQwUAYDVR0fBEkwRzBFoEOgQYY/aHR0cDov
// SIG // L2NybC5taWNyb3NvZnQuY29tL3BraS9jcmwvcHJvZHVj
// SIG // dHMvbWljcm9zb2Z0cm9vdGNlcnQuY3JsMFQGCCsGAQUF
// SIG // BwEBBEgwRjBEBggrBgEFBQcwAoY4aHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNyb3NvZnRS
// SIG // b290Q2VydC5jcnQwDQYJKoZIhvcNAQEFBQADggIBAFk5
// SIG // Pn8mRq/rb0CxMrVq6w4vbqhJ9+tfde1MOy3XQ60L/svp
// SIG // LTGjI8x8UJiAIV2sPS9MuqKoVpzjcLu4tPh5tUly9z7q
// SIG // QX/K4QwXaculnCAt+gtQxFbNLeNK0rxw56gNogOlVuC4
// SIG // iktX8pVCnPHz7+7jhh80PLhWmvBTI4UqpIIck+KUBx3y
// SIG // 4k74jKHK6BOlkU7IG9KPcpUqcW2bGvgc8FPWZ8wi/1wd
// SIG // zaKMvSeyeWNWRKJRzfnpo1hW3ZsCRUQvX/TartSCMm78
// SIG // pJUT5Otp56miLL7IKxAOZY6Z2/Wi+hImCWU4lPF6H0q7
// SIG // 0eFW6NB4lhhcyTUWX92THUmOLb6tNEQc7hAVGgBd3TVb
// SIG // Ic6YxwnuhQ6MT20OE049fClInHLR82zKwexwo1eSV32U
// SIG // jaAbSANa98+jZwp0pTbtLS8XyOZyNxL0b7E8Z4L5UrKN
// SIG // MxZlHg6K3RDeZPRvzkbU0xfpecQEtNP7LN8fip6sCvsT
// SIG // J0Ct5PnhqX9GuwdgR2VgQE6wQuxO7bN2edgKNAltHIAx
// SIG // H+IOVN3lofvlRxCtZJj/UBYufL8FIXrilUEnacOTj5XJ
// SIG // jdibIa4NXJzwoq6GaIMMai27dmsAHZat8hZ79haDJLmI
// SIG // z2qoRzEvmtzjcT3XAH5iR9HOiMm4GPoOco3Boz2vAkBq
// SIG // /2mbluIQqBC0N1AI1sM9MIIGBzCCA++gAwIBAgIKYRZo
// SIG // NAAAAAAAHDANBgkqhkiG9w0BAQUFADBfMRMwEQYKCZIm
// SIG // iZPyLGQBGRYDY29tMRkwFwYKCZImiZPyLGQBGRYJbWlj
// SIG // cm9zb2Z0MS0wKwYDVQQDEyRNaWNyb3NvZnQgUm9vdCBD
// SIG // ZXJ0aWZpY2F0ZSBBdXRob3JpdHkwHhcNMDcwNDAzMTI1
// SIG // MzA5WhcNMjEwNDAzMTMwMzA5WjB3MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSEwHwYDVQQDExhNaWNyb3NvZnQgVGltZS1T
// SIG // dGFtcCBQQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQCfoWyx39tIkip8ay4Z4b3i48WZUSNQrc7d
// SIG // GE4kD+7Rp9FMrXQwIBHrB9VUlRVJlBtCkq6YXDAm2gBr
// SIG // 6Hu97IkHD/cOBJjwicwfyzMkh53y9GccLPx754gd6udO
// SIG // o6HBI1PKjfpFzwnQXq/QsEIEovmmbJNn1yjcRlOwhtDl
// SIG // KEYuJ6yGT1VSDOQDLPtqkJAwbofzWTCd+n7Wl7PoIZd+
// SIG // +NIT8wi3U21StEWQn0gASkdmEScpZqiX5NMGgUqi+YSn
// SIG // EUcUCYKfhO1VeP4Bmh1QCIUAEDBG7bfeI0a7xC1Un68e
// SIG // eEExd8yb3zuDk6FhArUdDbH895uyAc4iS1T/+QXDwiAL
// SIG // AgMBAAGjggGrMIIBpzAPBgNVHRMBAf8EBTADAQH/MB0G
// SIG // A1UdDgQWBBQjNPjZUkZwCu1A+3b7syuwwzWzDzALBgNV
// SIG // HQ8EBAMCAYYwEAYJKwYBBAGCNxUBBAMCAQAwgZgGA1Ud
// SIG // IwSBkDCBjYAUDqyCYEBWJ5flJRP8KuEKU5VZ5KShY6Rh
// SIG // MF8xEzARBgoJkiaJk/IsZAEZFgNjb20xGTAXBgoJkiaJ
// SIG // k/IsZAEZFgltaWNyb3NvZnQxLTArBgNVBAMTJE1pY3Jv
// SIG // c29mdCBSb290IENlcnRpZmljYXRlIEF1dGhvcml0eYIQ
// SIG // ea0WoUqgpa1Mc1j0BxMuZTBQBgNVHR8ESTBHMEWgQ6BB
// SIG // hj9odHRwOi8vY3JsLm1pY3Jvc29mdC5jb20vcGtpL2Ny
// SIG // bC9wcm9kdWN0cy9taWNyb3NvZnRyb290Y2VydC5jcmww
// SIG // VAYIKwYBBQUHAQEESDBGMEQGCCsGAQUFBzAChjhodHRw
// SIG // Oi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpL2NlcnRzL01p
// SIG // Y3Jvc29mdFJvb3RDZXJ0LmNydDATBgNVHSUEDDAKBggr
// SIG // BgEFBQcDCDANBgkqhkiG9w0BAQUFAAOCAgEAEJeKw1wD
// SIG // RDbd6bStd9vOeVFNAbEudHFbbQwTq86+e4+4LtQSooxt
// SIG // YrhXAstOIBNQmd16QOJXu69YmhzhHQGGrLt48ovQ7DsB
// SIG // 7uK+jwoFyI1I4vBTFd1Pq5Lk541q1YDB5pTyBi+FA+mR
// SIG // KiQicPv2/OR4mS4N9wficLwYTp2OawpylbihOZxnLcVR
// SIG // DupiXD8WmIsgP+IHGjL5zDFKdjE9K3ILyOpwPf+FChPf
// SIG // wgphjvDXuBfrTot/xTUrXqO/67x9C0J71FNyIe4wyrt4
// SIG // ZVxbARcKFA7S2hSY9Ty5ZlizLS/n+YWGzFFW6J1wlGys
// SIG // OUzU9nm/qhh6YinvopspNAZ3GmLJPR5tH4LwC8csu89D
// SIG // s+X57H2146SodDW4TsVxIxImdgs8UoxxWkZDFLyzs7BN
// SIG // Z8ifQv+AeSGAnhUwZuhCEl4ayJ4iIdBD6Svpu/RIzCzU
// SIG // 2DKATCYqSCRfWupW76bemZ3KOm+9gSd0BhHudiG/m4LB
// SIG // J1S2sWo9iaF2YbRuoROmv6pH8BJv/YoybLL+31HIjCPJ
// SIG // Zr2dHYcSZAI9La9Zj7jkIeW1sMpjtHhUBdRBLlCslLCl
// SIG // eKuzoJZ1GtmShxN1Ii8yqAhuoFuMJb+g74TKIdbrHk/J
// SIG // mu5J4PcBZW+JC33Iacjmbuqnl84xKf8OxVtc2E0bodj6
// SIG // L54/LlUWa8kTo/0xggSdMIIEmQIBATCBkDB5MQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSMwIQYDVQQDExpNaWNyb3NvZnQg
// SIG // Q29kZSBTaWduaW5nIFBDQQITMwAAAQosea7XeXumrAAB
// SIG // AAABCjAJBgUrDgMCGgUAoIG2MBkGCSqGSIb3DQEJAzEM
// SIG // BgorBgEEAYI3AgEEMBwGCisGAQQBgjcCAQsxDjAMBgor
// SIG // BgEEAYI3AgEVMCMGCSqGSIb3DQEJBDEWBBQ/DWHzYa8a
// SIG // 0HzOVNDJcjhHOwP5QDBWBgorBgEEAYI3AgEMMUgwRqAs
// SIG // gCoARQBMAFMALgBUAGUAcwB0AFIAdQBuAFIAZQBzAHUA
// SIG // bAB0AHMALgBqAHOhFoAUaHR0cDovL21pY3Jvc29mdC5j
// SIG // b20wDQYJKoZIhvcNAQEBBQAEggEANMKtr7w/1gRG8s42
// SIG // 2ZELPv/nmRym7x++qm90az2D45DE0J01b42GOCbhhT3U
// SIG // z/WYovcMmqiJ2PfRYyuWkG1hm5isurugq0axFE6o6FDy
// SIG // Z/MkMRSacrVrB3/kXrG1lAtwnCugAeT0zS9qBtSlrO5L
// SIG // 220R7P9DJ1IiSGaSbfY35aG+uAhAn9KXHbP0fCkCaIoK
// SIG // HFDFT1PETvEsGB20wdIFoPfz0V4oqbPLQXeYh6mpW3Vo
// SIG // 2EASylJpluS9WrFTUAwdNZtNH2YLRTFzTSZv9mpVxpsg
// SIG // NXUNpYou8QOWA7/3LC4nfDQZAGjyunejphabO1UZl5C8
// SIG // /1BBydpsRCe1RsDDSqGCAigwggIkBgkqhkiG9w0BCQYx
// SIG // ggIVMIICEQIBATCBjjB3MQswCQYDVQQGEwJVUzETMBEG
// SIG // A1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9u
// SIG // ZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9u
// SIG // MSEwHwYDVQQDExhNaWNyb3NvZnQgVGltZS1TdGFtcCBQ
// SIG // Q0ECEzMAAABvZS1YbQcRRigAAAAAAG8wCQYFKw4DAhoF
// SIG // AKBdMBgGCSqGSIb3DQEJAzELBgkqhkiG9w0BBwEwHAYJ
// SIG // KoZIhvcNAQkFMQ8XDTE1MDYyOTA0MzQyOVowIwYJKoZI
// SIG // hvcNAQkEMRYEFD8cr/X4v8KpZZ/DIc/dRtOhqvoVMA0G
// SIG // CSqGSIb3DQEBBQUABIIBAEFpozvctP4WBT+WiYC75znQ
// SIG // D9tilCrEn9GkK3edSzN44U8dAuiNNCe3N7V/5RVEbgVG
// SIG // KTreaQwc2PMABqb9BZ0ZFY7XeCTO01JnPReYpIWP17Uh
// SIG // QT5SKXs91DyDIyHGfZtw8VwFGr6ZF9cTEB8xiHQhYj40
// SIG // 2MBzGRuQLTDYzUJWrzVBoc8jsYdKhpp2TT/sqENZtkJ8
// SIG // kef7lpiLmJVNv2y60TTaQJFIuBEZwZmLZqKw13WYmeIX
// SIG // TtH946Hg1WRsjQI0TlhIAOtDsrtl4kChWEO9DZkY4ORa
// SIG // 0mbQq367LJJ2XqVkY6xSQ8J5hnlPpus7SE0mSo6PtJy6
// SIG // eVDr3QO+ytI=
// SIG // End signature block
